% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spat_contour.R, R/geom_spat_contour_fill.R
\name{geom_spat_contour}
\alias{geom_spat_contour}
\alias{geom_spatraster_contour}
\alias{geom_spatraster_contour_filled}
\title{Plot SpatRaster contours}
\usage{
geom_spatraster_contour(
  mapping = NULL,
  data,
  ...,
  maxcell = 5e+05,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_spatraster_contour_filled(
  mapping = NULL,
  data,
  ...,
  maxcell = 5e+05,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A SpatRaster object.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{maxcell}{positive integer. Maximum number of cells to use for
the plot.}

\item{bins}{Number of contour bins. Overridden by \code{binwidth}.}

\item{binwidth}{The width of the contour bins. Overridden by \code{breaks}.}

\item{breaks}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggplot2 layer
}
\description{
These geoms create contours of SpatRaster objects.  To specify a valid
surface, you should specify the layer on \code{aes(z = layer_name)}, otherwise all
the layers would be consider for creating contours. See also \strong{Facets}
section.

The underlying implementation is based on \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.
}
\section{terra equivalent}{


\code{\link[terra:contour]{terra::contour()}}
}

\section{Aesthetics}{


\code{geom_spatraster_contour}() understands the following aesthetics:
\itemize{
\item z
\item alpha
\item colour
\item linetype
\item size
}

Additionally, \code{geom_spatraster_contour_filled()} understands also the
following aesthetics, as well as the ones listed above:
\itemize{
\item fill
}

Check \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}} for more info.
}

\section{Computed variables}{


This geom computes internally some variables that are available for use as
aesthetics, using (for example) \verb{aes(color = after_stat(<computed>))} (see
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}}).

\describe{
\item{\code{level}}{Height of contour. For contour lines, this is numeric vector
that represents bin boundaries. For contour bands, this is an ordered
factor that represents bin ranges.}
\item{\code{nlevel}}{Height of contour, scaled to maximum of 1.}
\item{\code{lyr}}{Name of the layer.}
\item{\code{level_low}, \code{level_high}, \code{level_mid}}{(contour bands only) Lower
and upper bin boundaries for each band, as well the mid point between
the boundaries.}
}
}

\section{Coords}{


When the SpatRaster does not present a crs (i.e.,
\code{terra::crs(rast) == ""}) the geom does not make any assumption on the
scales.

On SpatRaster that have a crs, the geom uses \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} to adjust
the scales. That means that also the \strong{SpatRaster may be reprojected}.
}

\section{Facets}{


You can use \code{ facet_wrap(~lyr)} for creating a faceted plot by each layer of
the SpatRaster object. See \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} for details.
}

\examples{
\donttest{
library(terra)

# Raster
f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

library(ggplot2)

ggplot() +
  geom_spatraster_contour(data = r) +
  facet_wrap(~lyr)

# Select one layer

ggplot() +
  geom_spatraster_contour(data = r, aes(z = tavg_04))
# With aes on computed variable

ggplot() +
  geom_spatraster_contour(
    data = r, aes(color = after_stat(level)),
    binwidth = 1,
    size = 0.4
  ) +
  facet_wrap(~lyr) +
  scale_color_gradientn(
    colours = hcl.colors(20, "Inferno"),
    guide = guide_coloursteps()
  ) +
  theme_minimal()

# Filled with breaks
ggplot() +
  geom_spatraster_contour_filled(data = r, breaks = seq(5, 20, 2.5)) +
  facet_wrap(~lyr)

# Both lines and contours aligned with breaks
ggplot() +
  geom_spatraster_contour_filled(
    data = r, breaks = seq(5, 20, 2.5),
    alpha = .7
  ) +
  geom_spatraster_contour(
    data = r, breaks = seq(5, 20, 2.5),
    color = "black"
  ) +
  facet_wrap(~lyr)
}

}
\seealso{
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}

Other ggplot2 utils:
\code{\link{autoplot}()},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}},
\code{\link{scale_fill_terrain}}
}
\concept{ggplot2.utils}
