% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.Spat.R
\name{rename}
\alias{rename}
\alias{rename.SpatRaster}
\alias{rename_with.SpatRaster}
\alias{rename.SpatVector}
\alias{rename_with.SpatVector}
\title{Rename layers/attributes}
\usage{
\method{rename}{SpatRaster}(.data, ...)

\method{rename_with}{SpatRaster}(.data, .fn, .cols = everything(), ...)

\method{rename}{SpatVector}(.data, ...)

\method{rename_with}{SpatVector}(.data, .fn, .cols = everything(), ...)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{For \code{rename()}: \code{tidy-select} Use \verb{new_name = old_name to rename}
selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should
return a character vector the same length as the input.}

\item{.cols}{\code{tidy-select} Columns to rename; defaults to all columns.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\code{rename()} changes the names of individual layers/attributes using
\code{new_name = old_name} syntax; \code{rename_with()} renames layers/attributes
using a function.
}
\section{terra equivalent}{


\verb{names(Spat*) <- c("a", "b", "c")}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:rename]{dplyr::rename()}} function.
\subsection{SpatRaster}{

Rename layers of a SpatRaster.
}

\subsection{SpatVector}{

This method relies on the implementation of \code{\link[dplyr:rename]{dplyr::rename()}} method on the
sf package. The result is a SpatVector with the renamed attributes on the
function call.
}
}

\examples{

library(terra)
f <- system.file("extdata/cyl_tile.tif", package = "tidyterra")
spatrast <- rast(f) \%>\% mutate(aa = 1, bb = 2, cc = 3)

spatrast

spatrast \%>\% rename(
  this_first = cyl_tile_1,
  this_second = cyl_tile_2
)

spatrast \%>\% rename_with(
  toupper,
  .cols = starts_with("c")
)
}
\seealso{
\code{\link[dplyr:rename]{dplyr::rename()}}

Other dplyr methods:
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{pull}()},
\code{\link{relocate}()},
\code{\link{select}()},
\code{\link{slice}()}

Other single table verbs: 
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{select}()},
\code{\link{slice}()}
}
\concept{dplyr.methods}
\concept{single table verbs}
