% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{check_order}
\alias{check_order}
\title{Perform a consistency check on observed and simulated data}
\usage{
check_order(obs, sim, tol = 1e-05)
}
\arguments{
\item{obs, sim}{A `data.frame` with 2 columns (see Details).}

\item{tol}{A tolerance for comparing time values.}
}
\value{
The number of replicates contained in `sim`.
}
\description{
This function performs a simple consistency check on an observed and
simulated dataset to make sure they are consistent with respect to ordering
as required by the other functions used in the VPC calculation.
}
\details{
The consistency check is performed by comparing a combination of unique
subject identifier (ID) and time. Both \code{data.frame} objects must be given with
those in positions 1 and 2, respectively.
}
\examples{

\donttest{

 require(data.table)
 
check_order(obs_data[, .(ID, TIME)], sim_data[, .(ID, TIME)])
}
}
\seealso{
\code{\link{observed}}, \code{\link{simulated}}.
}
