% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logpdfOU.R
\name{logpdfOU}
\alias{logpdfOU}
\title{Calculate log pdf of an Ornstein-Uhlenbeck process}
\usage{
logpdfOU(t, y, mean = 0, sd = 1, gamma = 1, cond = 0, log = FALSE)
}
\arguments{
\item{t}{vector of time points at which the OU process is available.}

\item{y}{vector of y-values corresponing to the t-values
(note that t and y need to be of the same length).}

\item{mean}{asymptotic mean of the process.}

\item{sd}{asymptotic standard deviation of the process.}

\item{gamma}{rate coefficient for return to the mean}

\item{cond}{conditioning: 0 indicates no conditioning, 1 conditioning to start value, and
2 conditioning to start and end value}

\item{log}{if true, the log pdf of the log of y is calculated
(mean and sd are interpreted in y, not in log(y) units)}
}
\value{
the function returns the log pdf
}
\description{
This function calculates the log pdf of a realization of an Ornstein-Uhlenbeck process
with given parameters. 
The calculation can be done for an Ornstein-Uhlenbeck process with a random start value,
for a process conditional on the start value, or for a process conditional on start and end values.
The function includes the option of performing the calculation for lognormal marginal generated by 
exponential tranformation.
}
\examples{
OU <- randOU(mean=0,sd=1,gamma=1,t=0:1000/1000)
logpdfOU(OU$t,OU$y,mean=0,sd=1,gamma=1)
}
