% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-yarn.R
\name{yarn}
\alias{yarn}
\title{R6 class containing XML representation of Markdown}
\description{
Wrapper around an XML representation of a Markdown document. It contains four
publicly accessible slots: path, yaml, body, and ns.
}
\details{
This class is a fancy wrapper around the results of \code{\link[=to_xml]{to_xml()}} and
has methods that make it easier to add, analyze, remove, or write elements
of your markdown document.
}
\examples{

## ------------------------------------------------
## Method `yarn$new`
## ------------------------------------------------

path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
ex1
path2 <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex2 <- tinkr::yarn$new(path2)
ex2

## ------------------------------------------------
## Method `yarn$reset`
## ------------------------------------------------


path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
# OH NO
ex1$body
ex1$body <- xml2::xml_missing()
ex1$reset()
ex1$body

## ------------------------------------------------
## Method `yarn$write`
## ------------------------------------------------

path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
ex1
tmp <- tempfile()
try(readLines(tmp)) # nothing in the file
ex1$write(tmp)
head(readLines(tmp)) # now a markdown file
unlink(tmp)

## ------------------------------------------------
## Method `yarn$show`
## ------------------------------------------------

path <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex2 <- tinkr::yarn$new(path)
ex2$head(5)
ex2$tail(5)
ex2$show()

## ------------------------------------------------
## Method `yarn$add_md`
## ------------------------------------------------

path <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex <- tinkr::yarn$new(path)
# two headings, no lists
xml2::xml_find_all(ex$body, "md:heading", ex$ns)
xml2::xml_find_all(ex$body, "md:list", ex$ns)
ex$add_md(
  "# Hello\n\nThis is *new* formatted text from `{tinkr}`!",
  where = 1L
)$add_md(
  " - This\n - is\n - a new list",
  where = 2L
)
# three headings
xml2::xml_find_all(ex$body, "md:heading", ex$ns)
xml2::xml_find_all(ex$body, "md:list", ex$ns)
tmp <- tempfile()
ex$write(tmp)
readLines(tmp, n = 20) 

## ------------------------------------------------
## Method `yarn$protect_math`
## ------------------------------------------------

path <- system.file("extdata", "math-example.md", package = "tinkr")
ex <- tinkr::yarn$new(path)
ex$tail() # math blocks are escaped :(
ex$protect_math()$tail() # math blocks are no longer escaped :)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{[\code{character}] path to file on disk}

\item{\code{yaml}}{[\code{character}] text block at head of file}

\item{\code{body}}{[\code{xml_document}] an xml document of the (R)Markdown file.}

\item{\code{ns}}{[\code{xml_document}] an xml namespace object defining "md" to
commonmark.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-yarn-new}{\code{yarn$new()}}
\item \href{#method-yarn-reset}{\code{yarn$reset()}}
\item \href{#method-yarn-write}{\code{yarn$write()}}
\item \href{#method-yarn-show}{\code{yarn$show()}}
\item \href{#method-yarn-head}{\code{yarn$head()}}
\item \href{#method-yarn-tail}{\code{yarn$tail()}}
\item \href{#method-yarn-add_md}{\code{yarn$add_md()}}
\item \href{#method-yarn-protect_math}{\code{yarn$protect_math()}}
\item \href{#method-yarn-clone}{\code{yarn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-new"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-new}{}}}
\subsection{Method \code{new()}}{
Create a new yarn document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$new(path = NULL, encoding = "UTF-8", sourcepos = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{[\code{character}] path to a markdown episode file on disk}

\item{\code{encoding}}{[\code{character}] encoding passed to \code{\link[=readLines]{readLines()}}}

\item{\code{sourcepos}}{passed to \code{\link[commonmark:commonmark]{commonmark::markdown_xml()}}. If \code{TRUE}, the
source position of the file will be included as a "sourcepos" attribute.
Defaults to \code{FALSE}.}

\item{\code{...}}{arguments passed on to \code{\link[=to_xml]{to_xml()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new yarn object containing an XML representation of a
(R)Markdown file.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
ex1
path2 <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex2 <- tinkr::yarn$new(path2)
ex2
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-reset"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-reset}{}}}
\subsection{Method \code{reset()}}{
reset a yarn document from the original file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$reset()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
# OH NO
ex1$body
ex1$body <- xml2::xml_missing()
ex1$reset()
ex1$body
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-write"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-write}{}}}
\subsection{Method \code{write()}}{
Write a yarn document to Markdown/R Markdown
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$write(path = NULL, stylesheet_path = stylesheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to the file you want to write}

\item{\code{stylesheet_path}}{path to the xsl stylesheet to convert XML to markdown.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{path <- system.file("extdata", "example1.md", package = "tinkr")
ex1 <- tinkr::yarn$new(path)
ex1
tmp <- tempfile()
try(readLines(tmp)) # nothing in the file
ex1$write(tmp)
head(readLines(tmp)) # now a markdown file
unlink(tmp)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-show"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-show}{}}}
\subsection{Method \code{show()}}{
show the markdown contents on the screen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$show(stylesheet_path = stylesheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stylesheet_path}}{path to the xsl stylesheet to convert XML to markdown.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a character vector with one line for each line in the output
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{path <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex2 <- tinkr::yarn$new(path)
ex2$head(5)
ex2$tail(5)
ex2$show()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-head"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-head}{}}}
\subsection{Method \code{head()}}{
show the head of the markdown contents on the screen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$head(n = 6L, stylesheet_path = stylesheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{the number of elements to show from the top. Negative numbers}

\item{\code{stylesheet_path}}{path to the xsl stylesheet to convert XML to markdown.
exclude lines from the bottom}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a character vector with \code{n} elements
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-tail"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-tail}{}}}
\subsection{Method \code{tail()}}{
show the tail of the markdown contents on the screen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$tail(n = 6L, stylesheet_path = stylesheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{the number of elements to show from the bottom. Negative numbers}

\item{\code{stylesheet_path}}{path to the xsl stylesheet to convert XML to markdown.
exclude lines from the top}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a character vector with \code{n} elements
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-add_md"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-add_md}{}}}
\subsection{Method \code{add_md()}}{
add an arbitrary Markdown element to the document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$add_md(md, where = 0L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{md}}{a string of markdown formatted text.}

\item{\code{where}}{the location in the document to add your markdown text.
This is passed on to \code{\link[xml2:xml_replace]{xml2::xml_add_child()}}. Defaults to 0, which
indicates the very top of the document.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{path <- system.file("extdata", "example2.Rmd", package = "tinkr")
ex <- tinkr::yarn$new(path)
# two headings, no lists
xml2::xml_find_all(ex$body, "md:heading", ex$ns)
xml2::xml_find_all(ex$body, "md:list", ex$ns)
ex$add_md(
  "# Hello\n\nThis is *new* formatted text from `{tinkr}`!",
  where = 1L
)$add_md(
  " - This\n - is\n - a new list",
  where = 2L
)
# three headings
xml2::xml_find_all(ex$body, "md:heading", ex$ns)
xml2::xml_find_all(ex$body, "md:list", ex$ns)
tmp <- tempfile()
ex$write(tmp)
readLines(tmp, n = 20) 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-protect_math"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-protect_math}{}}}
\subsection{Method \code{protect_math()}}{
Protect math blocks from being escaped
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$protect_math()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{path <- system.file("extdata", "math-example.md", package = "tinkr")
ex <- tinkr::yarn$new(path)
ex$tail() # math blocks are escaped :(
ex$protect_math()$tail() # math blocks are no longer escaped :)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yarn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-yarn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{yarn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
