% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_pca}
\alias{draw_pca}
\title{draw PCA plots}
\usage{
draw_pca(
  exp,
  group_list,
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#92C5DE", "#F4A582",
    "#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494",
    "#B3B3B3"),
  addEllipses = TRUE,
  style = "default",
  color.label = "Group"
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{color}{color vector}

\item{addEllipses}{logical,add ellipses or not}

\item{style}{plot style,"default","ggplot2"and "3D"}

\item{color.label}{color legend label}
}
\value{
a pca plot according to \code{exp} and grouped by \code{group}.
}
\description{
do PCA analysis and print a PCA plot
}
\examples{
draw_pca(t(iris[,1:4]),iris$Species)
exp <-  matrix(rnorm(60),nrow = 10)
colnames(exp) <- paste0("sample",1:6)
rownames(exp) <- paste0("gene",1:10)
exp[1:4,1:4]
group_list <- factor(rep(c("A","B"),each = 3))
draw_pca(exp,group_list)
draw_pca(exp,group_list,color = c("blue","red"))
}
\seealso{
\code{\link{draw_heatmap}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
