% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_or}
\alias{adjust_or}
\alias{adjust_or_with_continuous}
\title{Adjust an observed odds ratio for a normally distributed
confounder}
\usage{
adjust_or(
  effect_observed,
  exposure_confounder_effect,
  confounder_outcome_effect,
  verbose = TRUE,
  or_correction = FALSE
)

adjust_or_with_continuous(
  effect_observed,
  exposure_confounder_effect,
  confounder_outcome_effect,
  verbose = TRUE,
  or_correction = FALSE
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome odds ratio.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{exposure_confounder_effect}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{confounder_outcome_effect}{Numeric. Estimated relationship
between the unmeasured confounder and the outcome.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{or_correction}{Logical. Indicates whether to use a correction factor.
The methods used for this function are based on risk ratios. For rare
outcomes, an odds ratio approximates a risk ratio. For common outcomes,
a correction factor is needed. If you have a common outcome (>15\%),
set this to \code{TRUE}. Default: \code{FALSE}.}
}
\value{
Data frame.
}
\description{
Adjust an observed odds ratio for a normally distributed
confounder
}
\examples{
adjust_or(1.2, 0.9, 1.3)
}
