% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_tmap.R
\name{print.tmap}
\alias{print.tmap}
\alias{knit_print.tmap}
\title{Draw thematic map}
\usage{
\method{print}{tmap}(
  x,
  vp = NULL,
  return.asp = FALSE,
  mode = getOption("tmap.mode"),
  show = TRUE,
  knit = FALSE,
  options = NULL,
  ...
)

knit_print.tmap(x, ..., options = NULL)
}
\arguments{
\item{x}{tmap object. A tmap object is created with \code{\link{qtm}} or by stacking \code{\link{tmap-element}}s.}

\item{vp}{\code{\link[grid:viewport]{viewport}} to draw the plot in. This is particularly useful for insets.}

\item{return.asp}{Logical that determines whether the aspect ratio of the map is returned. In that case, \code{\link[grid:grid.newpage]{grid.newpage()}} will be called, but without plotting of the map. This is used by \code{\link{tmap_save}} to determine the aspect ratio of the map.}

\item{mode}{the mode of tmap: \code{"plot"} (static) or \code{"view"} (interactive). See \code{\link{tmap_mode}} for details.}

\item{show}{logical that determines whether to show to map. Obviously \code{TRUE} by default, but \code{show=FALSE} can be useful for just obtaining the returned objects.}

\item{knit}{should \code{\link[knitr:knit_print]{knit_print}} be enabled, or the normal \code{\link[base:print]{print}} function?}

\item{options}{options passed on to knitprint}

\item{...}{not used}
}
\value{
If \code{mode=="plot"}, then a list is returned with the processed shapes and the metadata. If \code{mode=="view"}, a \code{\link[leaflet:leaflet]{leaflet}} object is returned (see also \code{\link{tmap_leaflet}})
}
\description{
Draw thematic map. If the tmap mode is set to \code{"plot"} (see \code{\link{tmap_mode}}), the map is plot in the current graphics device. If the mode is set to \code{"view"}, the map is shown interactively as an htmlwidget.
}
