% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tmhmm_to_file.R
\name{run_tmhmm_to_file}
\alias{run_tmhmm_to_file}
\title{Creates a FASTA-like file, that has the locations
of the amino acids.}
\usage{
run_tmhmm_to_file(fasta_filename, tmhmm_filename)
}
\arguments{
\item{fasta_filename}{path to a FASTA file}

\item{tmhmm_filename}{filename to write the TMHMM results to}
}
\description{
Creates a FASTA-like file, that has the locations
of the amino acids.
}
\examples{
if (is_tmhmm_installed()) {

  # Write results to a temporary file
  tmhmm_filename <- tempfile()
  run_tmhmm_to_file(
    fasta_filename = system.file(
      "extdata", "tmhmm.fasta", package = "tmhmm"
    ),
    tmhmm_filename = tmhmm_filename
  )

  # Result is written to 'tmhmm_filename', cleaning up
  file.remove(tmhmm_filename)
}
}
