% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modstats.R
\name{eigengene}
\alias{eigengene}
\title{Calculate the eigengene of a module from a data set}
\usage{
eigengene(x, g, mset = NULL, k = 1)
}
\arguments{
\item{x}{data; genes in rows, samples in columns}

\item{g}{genes -- a vector gene IDs corresponding to annotation in modules}

\item{mset}{-- a module set; eigengenes will be calculated for each module in the set}

\item{k}{which component defines the eigengene (default: 1)}
}
\value{
A numeric matrix with rows corresponding to modules. If there
was not a sufficient number of genes in a module corresponding to the data
set, the row will contain only NA's.
}
\description{
Calculate the eigengene of a module from a data set
}
\details{
The eigengene of a module is here defined as the first principal
component of a PCA on the gene expression of all genes from a module.
}
\examples{
data(Egambia)
data(tmod)
x <- Egambia[ , -c(1:3) ]
ifns <- tmod[ grep("[Ii]nterferon", tmod$MODULES$Title) ]
eigv <- eigengene(x, Egambia$GENE_SYMBOL, ifns)
plot(eigv["LI.M127", ], eigv["DC.M1.2",])

# which interferon modules are correlated
cor(eigv) 
}
