% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_player_game.R
\name{bart_player_game}
\alias{bart_player_game}
\title{Get Player Game Stats}
\usage{
bart_player_game(
  year = current_season(),
  stat = NULL,
  game_id = NULL,
  player_id = NULL,
  exp = NULL,
  team = NULL,
  conf = NULL
)
}
\arguments{
\item{year}{Year to filter.}

\item{stat}{Indicates statistical split (see details).}

\item{game_id}{Game to filter.}

\item{player_id}{Player to filter.}

\item{exp}{Player experience to filter.}

\item{team}{Team to filter.}

\item{conf}{Conference to filter.}
}
\value{
Returns a tibble with the number of columns dependent on the value
  supplied to the `stat` argument.
}
\description{
Returns detailed game-by-game player statistics on a variety of splits.
}
\details{
Data is split on three statistical types, explained below: \describe{
\item{box}{Returns basic box score stats; sorts by ppg.}
\item{shooting}{Returns play-by-play shooting splits; sorts by ppg.}
\item{advanced}{Returns advanced metrics and possession-adjusted box score
statistics; sorts by recruiting rank.}}
}
\examples{
\donttest{bart_player_game(year=2022, stat='box')}

}
