% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_team_box.R
\name{bart_team_box}
\alias{bart_team_box}
\title{Get Team Box Stats}
\usage{
bart_team_box(
  year = NULL,
  start = NULL,
  end = NULL,
  team = NULL,
  conf = NULL,
  split = NULL,
  stat = "total",
  aggregate = FALSE,
  ...
)
}
\arguments{
\item{year}{Filters to year.}

\item{start}{Filters to starting year}

\item{end}{Filters to ending year}

\item{team}{Filters to team.}

\item{conf}{Filters to conf.}

\item{split}{Split to filter (see details).}

\item{stat}{Filters for agg. stats (total) or avg. stats (avg)}

\item{aggregate}{Aggregate all years (TRUE) or return per-year stats when
passing a range of years (FALSE; default)}

\item{...}{Any other parameter accepted by the API endpoint}
}
\value{
Returns a tibble with the number of columns dependent on the year.
}
\description{
Returns aggregate team stats back to 2008
}
\details{
The `split` argument filters the results by split, explained below:
\describe{ \item{result}{Wins and losses} \item{location}{Game location}
\item{month}{Game month} \item{type}{Game type}}
}
\examples{
\donttest{try(bart_team_box(split='month', team='Duke'))}
}
