% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_1_topicsPlot.R
\name{topicsScatterLegend}
\alias{topicsScatterLegend}
\title{Plot a distribution plot}
\usage{
topicsScatterLegend(
  bivariate_color_codes,
  filtered_test,
  num_popout = 1,
  way_popout_topics = "mean",
  user_spec_topics = NULL,
  allow_topic_num_legend = FALSE,
  scatter_show_axis_values = TRUE,
  y_axes_1 = 2,
  cor_var = "",
  label_x_name = "x",
  label_y_name = "y",
  save_dir,
  figure_format = "svg",
  scatter_popout_dot_size = c(1, 5),
  scatter_bg_dot_size = c(1, 5),
  scatter_legend_dots_alpha = 0.8,
  scatter_legend_bg_dots_alpha = 0.2,
  width = 10,
  height = 8,
  seed = 42
)
}
\arguments{
\item{bivariate_color_codes}{A vector of color codes specifying colors for 
different categories in the scatter plot. 
Default: c("#398CF9", "#60A1F7", "#5dc688", "#e07f6a", "#EAEAEA", "#40DD52", "#FF0000", "#EA7467", "#85DB8E").}

\item{filtered_test}{A data frame containing the input data for the scatter plot. 
Must include columns like `color_categories` and other variables used in the function.}

\item{num_popout}{The number of topics to "pop out" in each category. Default: 1.
Can be a single integer (applies to all categories) or a vector for specific categories.}

\item{way_popout_topics}{The method for selecting pop-out topics. Options: "mean", "max_y", or "max_x". Default: "mean".}

\item{user_spec_topics}{A vector of user-specified topics to highlight in the scatter plot. Default: NULL.}

\item{allow_topic_num_legend}{Logical; if TRUE, displays topic numbers in the legend. Default: FALSE.}

\item{scatter_show_axis_values}{Show values on the axises.}

\item{y_axes_1}{Specifies axis alignment for the scatter legend. Options: 1 (x-axis) or 2 (y-axis). Default: 2.}

\item{cor_var}{A string used for naming the correlation variable in labels or file names. Default: "".}

\item{label_x_name}{Label for the x-axis in the scatter plot. Default: "x".}

\item{label_y_name}{Label for the y-axis in the scatter plot. Default: "y".}

\item{save_dir}{Directory where the scatter legend plot will be saved. Default: "./results".}

\item{figure_format}{File format for the saved scatter plot. Examples: "svg", "png", "pdf". Default: "svg".}

\item{scatter_popout_dot_size}{Size of the dots for pop-out topics in the scatter legend. Set to "prevalence" for dot size changing based on topic prevalence. Default: 15.}

\item{scatter_bg_dot_size}{Size of the dots for background topics in the scatter legend. Default: 9.}

\item{scatter_legend_dots_alpha}{The transparency of the dots}

\item{scatter_legend_bg_dots_alpha}{The transparency of the dots}

\item{width}{Width of the saved scatter plot in inches. Default: 10.}

\item{height}{Height of the saved scatter plot in inches. Default: 8.}

\item{seed}{Seed for reproducibility, ensuring consistent plot generation. Default: 42.}
}
\description{
Plot a distribution plot
}
