% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R, R/gen-namespace.R
\name{torch_diff}
\alias{torch_diff}
\title{Computes the n-th forward difference along the given dimension.}
\usage{
torch_diff(self, n = 1L, dim = -1L, prepend = list(), append = list())
}
\arguments{
\item{self}{the tensor to compute the differences on}

\item{n}{the number of times to recursively compute the difference}

\item{dim}{the dimension to compute the difference along. Default is the last dimension.}

\item{prepend}{values to prepend to input along dim before computing the
difference. Their dimensions must be equivalent to that of input, and their
shapes must match input’s shape except on dim.}

\item{append}{values to append to input along dim before computing the
difference. Their dimensions must be equivalent to that of input, and their
shapes must match input’s shape except on dim.}
}
\description{
The first-order differences are given by \code{out[i] = input[i + 1] - input[i]}.
Higher-order differences are calculated by using \code{\link[=torch_diff]{torch_diff()}} recursively.
}
\note{
Only n = 1 is currently supported
}
\examples{
if (torch_is_installed()) {
a <- torch_tensor(c(1,2,3))
torch_diff(a)

b <- torch_tensor(c(4, 5))
torch_diff(a, append = b)

c <- torch_tensor(rbind(c(1,2,3), c(3,4,5)))
torch_diff(c, dim = 1)
torch_diff(c, dim = 2) 

}
}
