% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_soft_margin_loss}
\alias{nn_soft_margin_loss}
\title{Soft margin loss}
\usage{
nn_soft_margin_loss(reduction = "mean")
}
\arguments{
\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that optimizes a two-class classification
logistic loss between input tensor \eqn{x} and target tensor \eqn{y}
(containing 1 or -1).
}
\details{
\deqn{
  \mbox{loss}(x, y) = \sum_i \frac{\log(1 + \exp(-y[i]*x[i]))}{\mbox{x.nelement}()}
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)} where \eqn{*} means, any number of additional
dimensions
\item Target: \eqn{(*)}, same shape as the input
\item Output: scalar. If \code{reduction} is \code{'none'}, then same shape as the input
}
}

