% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-testopt.R
\name{test_optim}
\alias{test_optim}
\title{Test optimization function}
\usage{
test_optim(
  optim,
  ...,
  opt_hparams = list(lr = 0.01),
  test_fn = "beale",
  steps = 200,
  pt_start_color = "#5050FF7F",
  pt_end_color = "#FF5050FF",
  ln_color = "#FF0000FF",
  ln_weight = 2,
  bg_xy_breaks = 100,
  bg_z_breaks = 32,
  bg_palette = "viridis",
  ct_levels = 10,
  ct_labels = FALSE,
  ct_color = "#FFFFFF7F",
  plot_each_step = FALSE
)
}
\arguments{
\item{optim}{Torch optimizer function.}

\item{...}{Additional parameters (passed to \code{image} function).}

\item{opt_hparams}{A list with optimizer initialize parameters
(default \code{list(lr = 0.01)}).}

\item{test_fn}{A test function (default \code{"beale"}).}

\item{steps}{Number of steps to run (default \code{200}).}

\item{pt_start_color}{Starting point color (default \code{"#5050FF7F"})}

\item{pt_end_color}{Ending point color (default \code{"#FF5050FF"})}

\item{ln_color}{Line path color (default \code{"#FF0000FF"})}

\item{ln_weight}{Line path weight (default \code{2})}

\item{bg_xy_breaks}{Background X and Y resolution (default \code{100})}

\item{bg_z_breaks}{Background Z resolution (default \code{32})}

\item{bg_palette}{Background palette (default \code{"viridis"})}

\item{ct_levels}{Contour levels (default \code{10})}

\item{ct_labels}{Should show contour labels? (default \code{FALSE})}

\item{ct_color}{Contour color (default \code{"#FFFFFF7F"})}

\item{plot_each_step}{Should output each step? (default \code{FALSE})}
}
\value{
No return value, called for producing animated gifs
}
\description{
\code{test_optim()} function is useful to visualize how optimizers solve the
minimization problem by showing the convergence path using a test function.
User can choose any test optimization
\href{https://en.wikipedia.org/wiki/Test_functions_for_optimization}{functions}
provided by \code{torchopt}:

\code{"beale"}, \code{"booth"}, \code{"bukin_n6"}, \code{"easom"}, \code{"goldstein_price"},
\code{"himmelblau"}, \code{"levi_n13"}, \code{"matyas"}, \code{"rastrigin"},
\code{"rosenbrock"}, and \code{"sphere"}.

Besides these functions, users can pass any function that receives two
numerical values and returns a scalar.

Optimization functions are useful to evaluate characteristics of optimization
algorithms, such as convergence rate, precision, robustness, and performance.
These functions give an idea about the different situations that optimization
algorithms can face.

Function \code{test_function()} plot the 2D-space of a test optimization function.
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
