% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{config_dir}
\alias{config_dir}
\title{Get Normalized Configuration Directory Path of a Program}
\usage{
config_dir(
  app_name,
  cl_arg = {
     commandArgs()[grep("--config-dir", commandArgs()) + 1]
 },
  env_var = Sys.getenv(toupper(paste0(app_name, "_config_dir()"))),
  create = FALSE,
  sep = "/"
)
}
\arguments{
\item{app_name}{Name of the program/package/app}

\item{cl_arg}{Value of app specific commandline parameter}

\item{env_var}{Value of app specific environment variable}

\item{create}{whether to create returned path, if it doesn't exists yet}

\item{sep}{Path separator to be used on Windows}
}
\value{
Normalized path to the configuration directory of \verb{$app_name}.
}
\description{
\code{config_dir} returns the absolute, normalized path to the
configuration directory of a program/package/app based on an optional
app-specific commandline argument, an optional app-specific environment
variable and the \href{https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html}{XDG Base Directory Specification}
}
\details{
The following algorithm is used to determine the location of the
configuration directory for application \verb{$app_name}:
\enumerate{
\item If parameter \code{cl_arg} is a non-empty string, return it
\item Else, if parameter \code{env_var} is a non-empty string, return it
\item Else, if environment variable (EV) \code{XDG_CONFIG_HOME} exists, return
\verb{$XDG_CONFIG_HOME/$app_name}
\item Else, if EV \code{HOME} exists, return \verb{$HOME/.config/\{app_name\}}
\item Else, if EV \code{USERPROFILE} exists, return
\verb{$USERPROFILE/.config/\{app_name\}}
\item Else, return \verb{$WD/.config/\{app-name\}}
}

where \verb{$WD} equals the current working directory and the notation \verb{$VAR} is
used to specify the value of a parameter or environment variable VAR.
}
\examples{
config_dir("myApp")
}
\seealso{
\code{\link[=data_dir]{data_dir()}}, \code{\link[=config_file]{config_file()}}, \code{\link[=xdg_config_home]{xdg_config_home()}}
}
\keyword{path}
