## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE,
                      warning = FALSE,
                      message = FALSE)

## ----exportingBenchmarks-------------------------------------------------
library(dplyr)
library(toxEval)

path_to_file <- file.path(system.file("extdata", package="toxEval"),
                          "OWC_data_fromSup.xlsx") 
tox_list <- create_toxEval(path_to_file)
ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC = ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)


benchmarks <- ACC %>%
  filter(endPoint %in% filtered_ep$endPoint) %>%
  rename(Value = ACC_value,
         Chemical = chnm) %>%
  left_join(filtered_ep, by = "endPoint")

names(benchmarks)


## ----getRawBenchmarks----------------------------------------------------
raw_benchmarks <- read.csv(text='CAS,chm_nm,source,value
120-12-7,Anthracene,EPA_acute,86.1
50-32-8,Benzo(a)pyrene,EPA_acute,3.98
206-44-0,Fluoranthene,EPA_acute,29.6
91-20-3,Naphthalene,EPA_acute,803
85-01-8,Phenanthrene,EPA_acute,79.7
129-00-0,Pyrene,EPA_acute,42
98-82-8,Isopropylbenzene (cumene),EPA_acute,2140
1912-24-9,Atrazine,EPA_acute,360
57837-19-1,Metalaxyl,EPA_acute,14000
87-86-5,Pentachlorophenol,EPA_acute,19
1610-18-0,Prometon,EPA_acute,98
63-25-2,Carbaryl,EPA_acute,0.85
2921-88-2,Chlorpyrifos,EPA_acute,0.05
333-41-5,Diazinon,EPA_acute,0.17
62-73-7,Dichlorvos,EPA_acute,0.035
84852-15-3,"4-Nonylphenol, branched",EPA_acute,28
120-12-7,Anthracene,EPA_chronic,20.7
50-32-8,Benzo(a)pyrene,EPA_chronic,0.014
206-44-0,Fluoranthene,EPA_chronic,7.11
91-20-3,Naphthalene,EPA_chronic,24
85-01-8,Phenanthrene,EPA_chronic,6.3
129-00-0,Pyrene,EPA_chronic,10.1
84-66-2,Diethyl phthalate,EPA_chronic,220
90-12-0,1-Methylnaphthalene,EPA_chronic,2.1
91-57-6,2-Methylnaphthalene,EPA_chronic,4.7
98-82-8,Isopropylbenzene (cumene),EPA_chronic,2.6
1912-24-9,Atrazine,EPA_chronic,60
57837-19-1,Metalaxyl,EPA_chronic,100
87-86-5,Pentachlorophenol,EPA_chronic,13
63-25-2,Carbaryl,EPA_chronic,0.5
2921-88-2,Chlorpyrifos,EPA_chronic,0.04
333-41-5,Diazinon,EPA_chronic,0.043
62-73-7,Dichlorvos,EPA_chronic,0.0058
84852-15-3,"4-Nonylphenol, branched",EPA_chronic,6.6
106-46-7,"1,4-Dichlorobenzene",EPA_chronic,15
75-25-2,Tribromomethane (bromoform),EPA_chronic,320
80-05-7,Bisphenol A,other_acute,1518
120-12-7,Anthracene,other_acute,13
50-32-8,Benzo(a)pyrene,other_acute,0.24
206-44-0,Fluoranthene,other_acute,3980
91-20-3,Naphthalene,other_acute,190
85-01-8,Phenanthrene,other_acute,30
84-66-2,Diethyl phthalate,other_acute,1800
90-12-0,1-Methylnaphthalene,other_acute,37
78-59-1,Isophorone,other_acute,117000
127-18-4,Tetrachloroethene (PERC),other_acute,830
63-25-2,Carbaryl,other_acute,3.3
2921-88-2,Chlorpyrifos,other_acute,0.02
106-46-7,"1,4-Dichlorobenzene",other_acute,180
75-25-2,Tribromomethane (bromoform),other_acute,2300
80-05-7,Bisphenol A,other_chronic,0.86
120-12-7,Anthracene,other_chronic,0.012
50-32-8,Benzo(a)pyrene,other_chronic,0.015
206-44-0,Fluoranthene,other_chronic,0.04
91-20-3,Naphthalene,other_chronic,1.1
85-01-8,Phenanthrene,other_chronic,0.4
129-00-0,Pyrene,other_chronic,0.025
84-66-2,Diethyl phthalate,other_chronic,110
90-12-0,1-Methylnaphthalene,other_chronic,2.1
91-57-6,2-Methylnaphthalene,other_chronic,330
78-59-1,Isophorone,other_chronic,920
127-18-4,Tetrachloroethene (PERC),other_chronic,45
1912-24-9,Atrazine,other_chronic,1.8
314-40-9,Bromacil,other_chronic,5
51218-45-2,Metolachlor,other_chronic,7.8
63-25-2,Carbaryl,other_chronic,0.2
2921-88-2,Chlorpyrifos,other_chronic,0.002
84852-15-3,"4-Nonylphenol, branched",other_chronic,1
106-46-7,"1,4-Dichlorobenzene",other_chronic,9.4
75-25-2,Tribromomethane (bromoform),other_chronic,320',
stringsAsFactors = FALSE)

## ----setupBench----------------------------------------------------------
library(tidyr)

bench <- raw_benchmarks %>%
  rename(Value = value,
         Chemical = chm_nm) %>%
  separate(source, c("groupCol", "endPoint"), sep = "_")

head(bench)


## ----getToxList----------------------------------------------------------

tox_list_wq_bench <- tox_list
tox_list_wq_bench[["benchmarks"]] <- bench

tox_list_wq_bench <- as.toxEval(tox_list_wq_bench)


## ----plotStuff-----------------------------------------------------------
summary_bench <- get_chemical_summary(tox_list_wq_bench)

plot_tox_boxplots(summary_bench, category = "Chemical")

plot_tox_stacks(summary_bench,
                chem_site = tox_list_wq_bench$chem_site,
                category = "Chemical", include_legend = FALSE)

plot_tox_endpoints(summary_bench)


## ----heatmap, fig.height=10----------------------------------------------
plot_tox_heatmap(summary_bench, 
                 tox_list_wq_bench$chem_site, 
                 category = "Chemical")


