% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxbootHitParamCI.R
\name{toxbootHitParamCI}
\alias{toxbootHitParamCI}
\title{Performs Hit Call and Model Winner Selection on Bootstrap Results}
\usage{
toxbootHitParamCI(dat_db, dat_pipe)
}
\arguments{
\item{dat_db}{data.table, a data.table resulting from a toxboot query
minimally with columns m4id, max_med, hill_ga, hill_gw, hill_tp, hill_aic,
gnls_ga, gnls_gw, gnls_tp, gnls_la, gnls_lw, gnls_aic, cnst_aic}

\item{dat_pipe}{data.table. Minimally this data.table must have a column for
m4id and coff (cutoff value, used in determining the hitcall). Often use
the resulting data.table from \code{tcplLoadData(lvl = 5L)}.}
}
\value{
dat_boot, a data.table equivalent to dat_db with added columns coff
  (from dat_pipe), maic (winning model aic), modl (winning model), boot_hitc,
  modl_ga, modl_gw, modl_la, modl_lw, and modl_tp
}
\description{
\code{toxbootHitParamCI} takes input dose response data and returns a matrix
of sampled dose response values.
}
\details{
Based upon mc5 processing in \code{tcpl}.

  This function will first choose a winning model for each bootstrap
  replicate, based on that row's values for cnst_aic, hill_aic, gnls_aic.

  Second, if the winning model is hill or gnls, the max_med is greater than
  the cutoff, and the winning model modl_tp parameter is greater than the
  cutoff, the hitcall for that row is 1 (boot_hitc == 1).

  Finally, if boot_hitc == 1, values for modl_ga, modl_gw, and modl_tp are
  set to the corresponding values in the winning model. Else, these
  parameters are set to NA.
}
