% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_act.R
\name{calc_act_r}
\alias{calc_act_r}
\title{Calculate the auto-correlation time using only R. Consider using
\link{calc_act} instead, as it is orders of magnitude faster}
\usage{
calc_act_r(trace, sample_interval)
}
\arguments{
\item{trace}{the values}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the auto correlation time
}
\description{
Calculate the auto-correlation time using only R. Consider using
\link{calc_act} instead, as it is orders of magnitude faster
}
\examples{
  trace <- sin(seq(from = 0.0, to = 2.0 * pi, length.out = 100))
  act <- calc_act_r(
    trace = trace,
    sample_interval = 1
  )
  testthat::expect_equal(object = act, expected = 38.18202, tolerance = 0.01)
}
\seealso{
Java code can be found here: \url{https://github.com/CompEvol/beast2/blob/9f040ed0357c4b946ea276a481a4c654ad4fff36/src/beast/core/util/ESS.java#L161} # nolint URLs can be long
}
\author{
The original Java version of the algorithm was from Remco Bouckaert,
  ported to R and adapted by Richèl J.C. Bilderbeek
}
