% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{annotationText}
\alias{annotationText}
\alias{annotationText,PlotFeatureSet-method}
\alias{annotationText,ggplot-method}
\alias{annotationText,trellis-method}
\alias{annotationText,gTree-method}
\alias{annotationText,PlotFeatureSet-method}
\title{Accessor method for the annotation text (slot "annotationtext") of the plot object.}
\usage{
annotationText(object)

\S4method{annotationText}{PlotFeatureSet}(object)

\S4method{annotationText}{ggplot}(object)

\S4method{annotationText}{trellis}(object)

\S4method{annotationText}{gTree}(object)

\S4method{annotationText}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of class  PlotFeatureSet, GGplotFeatureSet, TrellisFeatureSet, ggplot, or trellis.}
}
\value{
A character vector of text annotations appearing on the plot.
}
\description{
Get the text annotations for a plot object.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
annotationText(fs)
}
