% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/ObjFeatureSet.R
\docType{methods}
\name{makeFeatureSet}
\alias{makeFeatureSet}
\alias{makeFeatureSet,ggplot-method}
\alias{makeFeatureSet,trellis-method}
\alias{makeFeatureSet,gTree-method}
\alias{makeFeatureSet,recordedplot-method}
\alias{makeFeatureSet,expression-method}
\alias{makeFeatureSet,call-method}
\alias{makeFeatureSet,FeatureSet-method}
\alias{makeFeatureSet,ANY-method}
\alias{makeFeatureSet,data.frame-method}
\title{Construct an ObjFeatureSet.}
\usage{
makeFeatureSet(object, ...)

\S4method{makeFeatureSet}{ggplot}(object, ...)

\S4method{makeFeatureSet}{trellis}(object, ...)

\S4method{makeFeatureSet}{gTree}(object, ...)

\S4method{makeFeatureSet}{recordedplot}(object, ...)

\S4method{makeFeatureSet}{expression}(object, ...)

\S4method{makeFeatureSet}{call}(object, ...)

\S4method{makeFeatureSet}{FeatureSet}(object, ...)

\S4method{makeFeatureSet}{ANY}(object, ...)

\S4method{makeFeatureSet}{data.frame}(object, ...)
}
\arguments{
\item{object}{The plot to summarize via metadata in an
ObjFeatureSet (or subclass)}

\item{...}{Other named arguments that become slots in the new
PlotFeatureSet.}
}
\value{
PlotFeatureSet S4 object containing a ObjFeatureSet object
    and extracted plot features
}
\description{
The generic function for transforming an R object into the
appropriate subclass of FeatureSet. This includes most introspection-based
metadata extraction from the object. Metadata extraction can be customized
at the package/R sesion level for specific classes of objects by
defining methods for this generic.
}
\section{Methods (by class)}{
\itemize{
\item \code{ggplot}: Construct a ObjFeatureSet from an object of class ggplot.

\item \code{trellis}: Construct a ObjFeatureSet from an object of class trellis.

\item \code{gTree}: Construct a ObjFeatureSet from an object of class gTree.

\item \code{recordedplot}: Construct a ObjFeatureSet from an object of class recordedplot.

\item \code{expression}: Construct a ObjFeatureSet from an unevaluated expression.

\item \code{call}: Construct a ObjFeatureSet from a call.

\item \code{FeatureSet}: No-op if we already have a ObjFeatureSet

\item \code{ANY}: Catch-all for attempted construction of a ObjFeatureSet from an object not of class ggplot or trellis.

\item \code{data.frame}: Construct a DFFeatureSet from a data.frame
}}

\examples{
library(ggplot2)
mt = datasets::mtcars
pg <- ggplot(mt, aes(wt, mpg)) + geom_point()
pfs <- makeFeatureSet(pg)

library(lattice)
titan <- datasets::Titanic
pl <- barchart(Class ~ Freq | Sex + Age, data = as.data.frame(titan),
               groups = Survived, stack = TRUE, layout = c(4, 1),
               auto.key = list(title = "Survived", columns = 2))
pfs <- makeFeatureSet(pl)

dffs <- makeFeatureSet(as.data.frame(titan))

\dontrun{
plot(1:10, 1:10)
pb <- recordPlot()
pfs <- makeFeatureSet(pb)
}
}
