% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.randomForest}
\alias{train.randomForest}
\title{train.randomForest}
\usage{
train.randomForest(formula, data, ..., subset, na.action = na.fail)
}
\arguments{
\item{formula}{a formula describing the model to be fitted (for the print method, an randomForest object).}

\item{data}{an optional data frame containing the variables in the model. By default the variables are taken from the environment which randomForest is called from.}

\item{...}{optional parameters to be passed to the low level function randomForest.default.}

\item{subset}{an index vector indicating which rows should be used. (NOTE: If given, this argument must be named.)}

\item{na.action}{A function to specify the action to be taken if NAs are found. (NOTE: If given, this argument must be named.)}
}
\value{
A object randomForest.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[randomForest]{randomForest}}.
}
\note{
the parameter information was taken from the original function  \code{\link[randomForest]{randomForest}}.
}
\examples{

data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.rf <- train.randomForest(Species~., data.train)
modelo.rf
prob <- predict(modelo.rf, data.test, type = "prob")
prob
prediccion <- predict(modelo.rf, data.test, type = "class")
prediccion
confusion.matrix(data.test, prediccion)

}
\seealso{
The internal function is from package \code{\link[randomForest]{randomForest}}.
}
