% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step2Selection.R
\name{Step2Selection}
\alias{Step2Selection}
\alias{print.trajSelection}
\alias{summary.trajSelection}
\title{Select a Subset of the Measures Using Factor Analysis}
\usage{
Step2Selection(trajMeasures, num.select = NULL, discard = NULL, select = NULL)

\method{print}{trajSelection}(x, ...)

\method{summary}{trajSelection}(object, ...)
}
\arguments{
\item{trajMeasures}{object of class \code{trajMeasures} as returned by
\code{\link[traj]{Step1Measures}}.}

\item{num.select}{an optional positive integer indicating the number of
factors to keep in the second stage of the algorithm. Defaults to \code{NULL} so
that all factors with variance greater than any one of the normalized
measures are selected.}

\item{discard}{an optional vector of positive integers corresponding to the
measures to be dropped from the analysis. See
\code{\link[traj]{Step1Measures}} for the list of measures. Defaults to
\code{NULL}.}

\item{select}{an optional vector of positive integers corresponding to the
measures to forcefully select. Defaults to \code{NULL}. If a vector is supplied,
the five-steps selection algorithm described above is bypassed and the
corresponding measures are selected instead.}

\item{x}{object of class \code{trajSelection}.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class  \code{trajSelection}.}
}
\value{
An object of class \code{trajSelection}; a list containing the values
of the selected measures, the output of the principal component analysis as
well as a curated form of the arguments.
}
\description{
This function applies the following dimension reduction algorithm
to the measures computed by \code{\link[traj]{Step1Measures}}:
\enumerate{
\item Drop the measures whose values are constant across the trajectories;
\item Use principal component analysis (PCA) on the measures to form factors summarizing the variability in the measures;
\item Drop the factors whose variance is smaller than any one of the standardized measures;
\item Perform a varimax rotation on the remaining factors;
\item For each rotated factor, select the measure that has the highest correlation (aka factor loading) with it and that hasn't yet been selected;
\item Drop the remaining measures.
}
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m = Step1Measures(trajdata.noGrp, measure = c(1:18), ID = TRUE)
s = Step2Selection(m)

print(s)

s2 = Step2Selection(m, select = c(3, 13, 11, 15))
}


}
\references{
Leffondre K, Abrahamowicz M, Regeasse A, Hawker GA, Badley EM,
McCusker J, Belzile E. Statistical measures were proposed for identifying
longitudinal patterns of change in quantitative health indicators. J Clin
Epidemiol. 2004 Oct;57(10):1049-62. doi: 10.1016/j.jclinepi.2004.02.012.
PMID: 15528056.
}
\seealso{
\code{\link[psych]{principal}} \code{\link[traj]{Step1Measures}}
}
