% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostrap-stability.R
\name{bootstrap_stability}
\alias{bootstrap_stability}
\title{Bootstrap stability for TRAMICP}
\usage{
bootstrap_stability(
  object,
  B = 100,
  size = NULL,
  verbose = FALSE,
  return_all = FALSE
)
}
\arguments{
\item{object}{Object of class \code{"dICP"}}

\item{B}{Numeric; number of bootstrap iterations}

\item{size}{Numeric; size of bootstrap samples}

\item{verbose}{Logical; print a progress bar (default: \code{FALSE})}

\item{return_all}{Logical; return all \code{"dICP"} objects (default:
\code{FALSE})}
}
\value{
Table of output sets of candidate causal predictors
}
\description{
Bootstrap stability for TRAMICP
}
\examples{
set.seed(12)
d <- dgp_dicp(n = 1e3, mod = "binary")
res <- glmICP(Y ~ X1 + X2 + X3, data = d, env = ~ E,
    family = "binomial", test = "cor.test")
bootstrap_stability(res, B = 2)

}
