% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssRegression.R
\name{xpssRegression}
\alias{xpssRegression}
\title{Calculates a linear Regression}
\usage{
xpssRegression(x, variables = NULL, dependent, method = enter(),
missing = "listwise", statistics = c("COEFF", "OUTS", "R", "ANOVA"), origin = FALSE)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class "xpssFrame".}

\item{variables}{vector with independent Variables as characters}

\item{dependent}{dependent Variable as character}

\item{method}{regression method to apply. Currently only \code{enter()} is implemented}

\item{missing}{Method to handle missing values. Currently only listwise is implemented}

\item{statistics}{character vector, which statistics should be in the output. Currently the function will return standard \code{\link{lm}} output. Only output for ANOVA is optional}

\item{origin}{Should the constant be compressed?}
}
\value{
returns a list of lists, each applied method is its own list with regression, anova and beta-coeffizients as elements
}
\description{
R Implementation of the SPSS \code{REGRESSION} Function.xpssRegression calculates linear regressions with associated statistics and plots.
}
\details{
Implementation from SPSS Regression in R
}
\examples{
data(fromXPSS)

xpssRegression(x = fromXPSS,
 		variables = c("V7_1","V7_2"),
 		dependent = "V5",
 		method = list(enter()))
}
\author{
Martin Schneider
}

