% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCrossTerms.R
\name{fit_trawl_intersection_LM}
\alias{fit_trawl_intersection_LM}
\title{Finds the intersection of two long memory (LM) trawl sets}
\usage{
fit_trawl_intersection_LM(alpha1, H1, alpha2, H2, plotdiag = FALSE)
}
\arguments{
\item{alpha1, H1, alpha2, H2}{parameters of the two long memory trawls}

\item{plotdiag}{binary variable specifying whether or not diagnostic plots
should be provided}
}
\value{
the Lebesgue measure of the intersection of the two trawl sets
}
\description{
Finds the intersection of two long memory (LM) trawl sets
}
\details{
Computes \eqn{R_{12}(0)=\mbox{Leb}(A_1 \cap A_2)} based on two trawl
 functions \eqn{g_1} and \eqn{g_2}.
}
\examples{
#Compute the intersection of two long memory trawls
fit_trawl_intersection_LM(0.1,1.1,0.2,1.2)
}
