% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyRF.R
\name{tidyRF}
\alias{tidyRF}
\title{Tidy Random Forest}
\usage{
tidyRF(rfobj, trainX, trainY)
}
\arguments{
\item{rfobj}{A random forest object. Currently, supported libraries include
\code{randomForest} and \code{ranger}.}

\item{trainX}{A data frame. Train set features.}

\item{trainY}{A data frame. Train set responses.}
}
\value{
A list of class \code{tidyRF}, with entries:
  \describe{
    \item{\code{num.classes}}{An integer. For classification trees, number
      of classes of the response. For regression trees, this field will
      always be 1.}
    \item{\code{num.trees}}{An integer. Number of trees.}
    \item{\code{feature.names}}{A vector. Names of features.}
    \item{\code{inbag.counts}}{A list. For each tree, a vector of the number
       of times the observations are in-bag in the trees.}
    \item{\code{left.children}}{A list. For each tree, a vector of the left
      children of its nodes.}
    \item{\code{right.children}}{A list. For each tree, a vector of the
      right children of its nodes.}
    \item{\code{split.features}}{A list. For each tree, a vector of the
      indices of features used at its nodes. Indices start from 0. A value
      of 0 means the node is terminal. This does not cause ambiguity,
      because the root node will never be a child of other nodes.}
    \item{\code{split.values}}{A list. For each tree, a vector of the
      values of features used at its nodes.}
    \item{\code{node.sizes}}{A list. For each tree, a vector of the sizes
      of its nodes.}
    \item{\code{node.resp}}{A list. For each tree, a vector of the responses
      of its nodes.}
    \item{\code{delta.node.resp.left}}{A list. For each tree, a vector of
      the difference between the responses of the left children of its nodes
      and themselves.}
    \item{\code{delta.node.resp.right}}{A list. For each tree, a vector of
      the difference between the responses of the right children of its
      nodes and themselves.}
  }
}
\description{
Converts random forest objects from various libraries into a common
structure, i.e. a ``tidy'' random forest, calculating absent auxiliary
information on demand, in order to provide a uniform interface for other
\code{tree.interpreter} functions. Note that the output is of a private
format, and is subject to change.
}
\examples{
library(ranger)
rfobj <- ranger(Species ~ ., iris, keep.inbag=TRUE)
tidy.RF <- tidyRF(rfobj, iris[, -5], iris[, 5])
str(tidy.RF, max.level=1)

}
