% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulltreedata.table.R
\name{pulltreedata.table}
\alias{pulltreedata.table}
\title{Returns the character matrix or phylogeny from a treedata.table object}
\usage{
pulltreedata.table(tdObject, type = c("dat", "phy"))
}
\arguments{
\item{tdObject}{A treedata.table object}

\item{type}{Whether the output of the function is a tree ('type="phylo"')
or a data.table ('type="dat"')}
}
\value{
A \code{data.table} or \code{phylo} object from the original \code{treedata.table}
object
}
\description{
Returns the character matrix or phylogeny from a treedata.table object
}
\examples{
data(anolis)
td <- as.treedata.table(anolis$phy, anolis$dat)
pulltreedata.table(td, type = "phy")
pulltreedata.table(td, type = "dat")
}
