% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs_for_attributes.R
\name{define}
\alias{define}
\alias{at_mutate}
\alias{define_}
\alias{at_mutate_}
\alias{keep}
\alias{at_select}
\alias{keep_}
\alias{at_select_}
\alias{rebrand}
\alias{at_rename}
\alias{rebrand_}
\alias{at_rename_}
\alias{take}
\alias{at_slice}
\alias{take_}
\alias{at_slice_}
\title{Manipulate attributes in a dplyr fashion}
\usage{
define(obj, ...)

at_mutate(obj, ...)

define_(obj, ..., .dots)

at_mutate_(obj, ..., .dots)

keep(obj, ...)

at_select(obj, ...)

keep_(obj, ..., .dots)

at_select_(obj, ..., .dots)

rebrand(obj, ...)

at_rename(obj, ...)

rebrand_(obj, ..., .dots)

at_rename_(obj, ..., .dots)

take(obj, at)

at_slice(obj, at)

take_(obj, at)

at_slice_(obj, at)
}
\arguments{
\item{obj}{An object.}

\item{...}{Comma separated list of unquoted expressions.}

\item{.dots}{Used to work around non-standard evaluation.}

\item{at}{Attribute to be obtained.}
}
\value{
\code{take} returns the attribute chosen. 
The other functions return \code{obj} with possibly modified attributes.
}
\description{
The function \code{define} (synonym: \code{at_mutate}) 
adds or changes attributes to \code{obj}. 

The function \code{keep} (synonym: \code{at_select}) 
selects attributes of \code{obj}, and removes the others. 

The function \code{rebrand} (synonym: \code{at_rename}) 
renames attributes of \code{obj}. 

The function \code{take} (synonym: \code{at_slice}) 
chooses a specific attribute and returns it.
}
\examples{
library(dplyr)
df <- data.frame(x = sample(10, 5, rep = TRUE),
                 y = sample(10, 5, rep = TRUE)) \%>\%
  define(example="yes",
         package="dplyr")
tribe(df)

take(df, names)
take_(df, "class")
take_(df, ~ package)

df <- df \%>\%
  define_(package = ~ NULL,
          example = ~ "no")
tribe(df)

df <- df \%>\% 
  define_(.dots = list(x =~ 2, y =~ c(3,4)))
tribe(df)

}
\seealso{
\code{\link{structure}}, \code{\link{attributes}}
}
