% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian-heads-cts.R
\name{dist_hdr}
\alias{dist_hdr}
\title{Compute highest density region for a density function}
\usage{
dist_hdr(dist, conf_level, bounds = attr(dist, "limits"))
}
\arguments{
\item{dist}{A one-argument function}

\item{conf_level}{A scalar between 0 and 1}

\item{bounds}{A length 2 vector of the bounds of the distribution's support}
}
\value{
A length 2 vector of region endpoints
}
\description{
This is a wrapper for \code{hdrcde::hdr}. The highest density region is the
interval that covers \code{conf_level} of the data and has the highest
average density. See:
}
\details{
Rob J Hyndman (1996) “Computing and graphing highest density regions”. American Statistician,
50, 120-126.
}
\examples{

d1 <- update_prior(33, 50, P = 0.5, prior = stats::dunif)
dist_hdr(d1, 0.95)

}
