% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_rolling.R
\name{predict_rolling}
\alias{predict_rolling}
\alias{predict_rolling.nlVar}
\title{Rolling forecasts}
\usage{
predict_rolling(object, ...)

\method{predict_rolling}{nlVar}(object, nroll = 10, n.ahead = 1, refit.every, newdata, ...)
}
\arguments{
\item{object}{A linear object of class \sQuote{\code{nlVar}}; generated by
\code{\link{lineVar}} or \code{\link{VECM}}.}

\item{\dots}{Currently not used.}

\item{nroll}{The number of rolling forecasts}

\item{n.ahead}{An integer specifying the number of forecast steps.}

\item{refit.every}{Determines every how many periods the model is
re-estimated.}

\item{newdata}{In case the given model is already estimated on the
sub-sample, the out-of-sample data can be provided with this argument. Note it should contain
observations to predict the first values, that are also contained in the
in-sample.}
}
\value{
A matrix containing the forecasts.
}
\description{
Forecasts a VAR or VECM by discarding a part of the sample, and recursively generating a
series of updated forecasts.
}
\details{
This function allows to check the out-of sample forecasting accuracy by
estimating the model on a sub-sample of the original, then making
\code{nroll} forecasts of horizon \code{n.ahead}, each time by updating the
sample. In other words, with a given model estimated on 100 observations, the
function will estimate it on say 90 first obs (\code{nroll=10}), generate a
say 1 step-ahead (\code{n.ahead=1}) from obs 90, then using true value 91 for 
to predict value at 92, etc, till the full sample is used.  

Unlike with usual \command{predict()} methods, specifiying \code{n.ahead=2} will
not generate a 1 step-ahead and a 2 step-ahead forecasts, but only
\code{nroll} 2 step-ahead forecasts.

Note that while the forecasts are updated with new values, the model
estimation is (by default) not updated. This can however be done with the
argument \code{fit.every}, specifiying at which frequency the model should be
re-estimated. By setting it to 1 for example, each time a new observation is
taken, the model is reestimated. This is similar to the
\code{\link[rugarch]{ugarchroll}} in package \pkg{rugarch}.
}
\examples{


data(barry)

## model estimated on full sample:
mod_vec <- VECM(barry, lag=2)

## generate 10 1-step-ahead forecasts:
preds_roll <- predict_rolling(mod_vec, nroll=10)

## plot the results:
plot(window(barry[,"dolcan"],start=1998), type="l", ylab="barry: dolcan")
preds_roll_ts <- ts(preds_roll$pred, start=time(barry)[nrow(barry)-10], freq=12)
lines(preds_roll_ts[,"dolcan"], col=2, lty=2)
legend("bottomright", lty=c(1,2), col=1:2, leg=c("True", "Fitted"))
title("Comparison of true and rolling 1-ahead forecasts\n")


}
\seealso{
\code{\link{predict.nlar}} for the standard predict function.
}
\author{
Matthieu Stigler
}
\keyword{predict}
