% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holiday.R
\name{holiday_aus}
\alias{holiday_aus}
\title{Australian national and state-based public holiday}
\usage{
holiday_aus(year, state = "national")
}
\arguments{
\item{year}{A vector of integer(s) indicating year(s).}

\item{state}{A state in Australia including "ACT", "NSW", "NT", "QLD", "SA",
"TAS", "VIC", "WA", as well as "national".}
}
\value{
A tibble consisting of \code{holiday} labels and their associated dates
in the year(s).
}
\description{
Australian national and state-based public holiday
}
\details{
Not documented public holidays:
\itemize{
\item AFL public holidays for Victoria
\item Queen's Birthday for Western Australia
\item Royal Queensland Show for Queensland, which is for Brisbane only
This function requires "timeDate" to be installed.
}
}
\examples{
holiday_aus(2016, state = "VIC")
holiday_aus(2013:2016, state = "ACT")
}
\references{
\href{https://www.australia.gov.au/about-australia/special-dates-and-events/public-holidays}{Public holidays}
}
