% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolling.R
\name{slide_tsibble}
\alias{slide_tsibble}
\title{Perform sliding windows on a tsibble by row}
\usage{
slide_tsibble(.x, .size = 1, .step = 1, .id = ".id")
}
\arguments{
\item{.x}{A tsibble.}

\item{.size}{A positive integer for window size.}

\item{.step}{A positive integer for calculating at every specified step
instead of every single step.}

\item{.id}{A character naming the new column \code{.id} containing the partition.}
}
\description{
\lifecycle{questioning}
}
\section{Rolling tsibble}{

\code{slide_tsibble()}, \code{tile_tsibble()}, and \code{stretch_tsibble()} provide fast
and shorthand for rolling over a tsibble by observations. That said, if the
supplied tsibble has time gaps, these rolling helpers will ignore those gaps
and proceed.

They are useful for preparing the tsibble for time series cross validation.
They all return a tsibble including a new column \code{.id} as part of the key. The
output dimension will increase considerably with \code{slide_tsibble()} and
\code{stretch_tsibble()}, which is likely to run out of memory when the data is
large.
}

\examples{
harvest <- tsibble(
  year = rep(2010:2012, 2),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = fruit, index = year
)
harvest \%>\%
  slide_tsibble(.size = 2)
}
\seealso{
Other rolling tsibble: 
\code{\link{stretch_tsibble}()},
\code{\link{tile_tsibble}()}
}
\concept{rolling tsibble}
\keyword{internal}
