% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_rf.R
\name{ts_rf}
\alias{ts_rf}
\title{Random Forest}
\usage{
ts_rf(preprocess = NA, input_size = NA, nodesize = 1, ntree = 10, mtry = NULL)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{nodesize}{node size}

\item{ntree}{number of trees}

\item{mtry}{number of attributes to build tree}
}
\value{
returns a \code{ts_rf} object.
}
\description{
Creates a time series prediction object that
uses the Random Forest.
It wraps the randomForest library.
}
\examples{
library(daltoolbox)
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_rf(ts_norm_gminmax(), input_size=4, nodesize=3, ntree=50)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
