% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_channel_stats.R
\name{get_channel_stats}
\alias{get_channel_stats}
\title{Get statistics of a Channel}
\usage{
get_channel_stats(channel_id = NULL, ...)
}
\arguments{
\item{channel_id}{Character. Id of the channel}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
nested named list with top element names:
\code{kind, etag, id, snippet (list of details of the channel including title), statistics (list of 5)}

If the \code{channel_id} is mistyped or there is no information, an empty list is returned
}
\description{
Get statistics of a Channel
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_channel_stats(channel_id="UCMtFAi84ehTSYSE9XoHefig")
get_channel_stats(channel_id="UCMtFAi84ehTSYSE9Xo") # Incorrect channel ID
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}

