% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect_predictions}
\alias{collect_predictions}
\alias{collect_metrics}
\title{Obtain and format results produced by tuning functions}
\usage{
collect_predictions(x)

collect_metrics(x, summarize = TRUE)
}
\arguments{
\item{x}{The results of \code{\link[=tune_grid]{tune_grid()}}, \code{\link[=tune_bayes]{tune_bayes()}}, \code{\link[=fit_resamples]{fit_resamples()}},
or \code{\link[=last_fit]{last_fit()}}. For \code{\link[=collect_predictions]{collect_predictions()}}, the control option \code{save_pred = TRUE} should have been used.}

\item{summarize}{A logical; should metrics be summarized over resamples
(\code{TRUE}) or return the values for each individual resample. Note that, if \code{x}
is created by \code{\link[=last_fit]{last_fit()}}, \code{summarize} has not effect.}
}
\value{
A tibble. The column names depend on the results and the mode of the
model.

For \code{\link[=collect_metrics]{collect_metrics()}} and \code{\link[=collect_predictions]{collect_predictions()}}, there are columns for
each tuning parameter (using the \code{id} from \code{\link[=tune]{tune()}}, if any).

For \code{\link[=collect_predictions]{collect_predictions()}}, there are additional columns for the resampling
identifier(s), columns for the predicted values (e.g., \code{.pred},
\code{.pred_class}, etc.), and a column for the outcome(s) using the original
column name(s) in the data.

\code{\link[=collect_metrics]{collect_metrics()}} also has columns \code{.metric}, and \code{.estimator}.  When the
results are summarized, there are columns for \code{mean}, \code{n}, and \code{std_err}.
When not summarized, the additional columns for the resampling identifier(s)
and \code{.estimate}.
}
\description{
Obtain and format results produced by tuning functions
}
\examples{
\donttest{
data("example_ames_knn")

# Summarized over resamples
collect_metrics(ames_grid_search)

# Per-resample values
collect_metrics(ames_grid_search, summarize = FALSE)

# ---------------------------------------------------------------------------

library(parsnip)
library(rsample)

lm_mod <-linear_reg() \%>\% set_engine("lm")
set.seed(93599150)
car_folds <- vfold_cv(mtcars)
ctrl <- control_resamples(save_pred = TRUE)

resampled <- fit_resamples(mpg ~ ., lm_mod, resamples = car_folds, control = ctrl)
collect_predictions(resampled)
}
}
