% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_simtuts.r
\name{simtuts}
\alias{simtuts}
\title{Generating time-uncertain time series}
\usage{
simtuts(N, Harmonics, sin.ampl, cos.ampl, trend = 0, y.sd, ti.sd)
}
\arguments{
\item{N}{A number of observations.}

\item{Harmonics}{A vector of three harmonics, typically integers.}

\item{sin.ampl}{A vector of three amplitudes of the sine terms.}

\item{cos.ampl}{vector of three amplitudes of the cosine terms.}

\item{trend}{A constant trend.}

\item{y.sd}{A standard deviation of observations.}

\item{ti.sd}{A standard deviation of estimates of timing.}
}
\description{
\code{simtuts} function generates time-uncertain time series. It returns two data frames
containing simulation of an actual process and its observations.\cr
The actual process consists of a sum of a constant, a linear trend, and three sine and three cosine functions, and its
observations are normally distributed \emph{y.obs~N(y.act, y.sd)}.\cr
Timing of simulated processes is modeled  as \emph{t.act~U(0,N)} and sorted in the ascending order.
Observations of timings are modeled  in two ways:
\enumerate{
\item  Normally distributed timing \emph{t.obs.norm~N(ti.act,ti.sd)},
sorted from the smallest to the largest value to ensure non-overlapping feature of observations,
\item Timing simulated with truncated normal distribution t.obs.tnorm~N(ti.act,ti.sd,....).}
Note: variability of timing can be substantially greater when the normal distribution is chosen,
the truncated distribution utilizes enforced limits applied in the midpoints of the actual timing.
}
\examples{
# 1. Generate actual and observed time series as a sum of 2 sine functions:
DATA=simtuts(N=50,Harmonics=c(10,20,0), sin.ampl=c(10,10, 0), cos.ampl=c(0,0,0),trend=0,
y.sd=2, ti.sd=0.3)

}
\references{
\url{https://en.wikipedia.org/wiki/Truncated_normal_distribution}
}
