% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bw}
\alias{bw}
\alias{bw.default}
\alias{bw.list}
\title{Bandwidth Selection by Cross-Validation}
\usage{
bw(x, ...)

\method{bw}{default}(x, y, z = NULL, est = c("lc", "ll"),
  tkernel = c("Epa", "Gaussian"), singular.ok = TRUE, ...)

\method{bw}{list}(x, y, z = NULL, est = c("lc", "ll"), tkernel = c("Epa",
  "Gaussian"), singular.ok = TRUE, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{Other parameters passed to specific methods.}

\item{y}{A matrix or vector with the dependent variable(s).}

\item{z}{A vector with the variable over which coefficients are smooth over.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{The type of kernel used in the coefficients estimation method,
one of Epanesnikov ("Epa") or "Gaussian".}

\item{singular.ok}{Logical. If FALSE, a singular model is an error.}
}
\value{
\code{bw} returns a vector or a scalar with the bandwith to estimate the mean or the covariance
residuals, fitted values.

A scalar or a vector of scalars.
}
\description{
Calculate bandwidth(s) by cross-validation for functions tvSURE, tvVAR and tvLM.
}
\examples{
tau <- seq(1:200)/200
beta <- data.frame(beta1 = sin(2*pi*tau), beta2 =  2*tau)
X <- data.frame(X1 = rnorm(200), X2 =  rchisq(200, df = 4))
error <- rt(200, df = 10)
y <- apply(X*beta, 1, sum) + error
bw <- bw(X, y, est = "ll", tkernel = "Gaussian")
model.tv <-  tvOLS(x = X, y = y, bw = bw)

data( Kmenta, package = "systemfit" )
## x is a list of matrices containing the regressors, one matrix for each equation
x <- list()
x[[1]] <- Kmenta[, c("price", "income")]
x[[2]] <- Kmenta[, c("price", "farmPrice", "trend")]

## y is a matrix with one column for each equation
y <- cbind(Kmenta$consump, Kmenta$consump)

## Calculate bandwidth
bw <- bw(x = x, y = y)

##One bandwidth per equation
print(bw)

##Use these bandwidths to estimate the time-varying coefficients
tvgls <- tvGLS(x = x, y = y, bw = bw)

}
