% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_Q}
\alias{est_Q}
\title{Estimate the Outcome Mechanism}
\usage{
est_Q(
  Y,
  C_cens = rep(1, length(Y)),
  A,
  W,
  delta = 0,
  samp_weights = rep(1, length(Y)),
  fit_type = c("sl", "glm"),
  glm_formula = "Y ~ .",
  sl_learners = NULL
)
}
\arguments{
\item{Y}{A \code{numeric} vector of observed outcomes.}

\item{C_cens}{A \code{numeric} vector of loss to follow-up indicators.}

\item{A}{A \code{numeric} vector of observed exposure values.}

\item{W}{A \code{numeric} matrix of observed baseline covariate values.}

\item{delta}{A \code{numeric} indicating the magnitude of the shift to be
computed for the exposure \code{A}. This is passed to the internal
\code{\link{shift_additive}} and is currently limited to additive shifts.}

\item{samp_weights}{A \code{numeric} vector of observation-level sampling
weights, as produced by the internal procedure to estimate the two-phase
sampling mechanism \code{\link{est_samp}}.}

\item{fit_type}{A \code{character} indicating whether to use GLMs or Super
Learner to fit the outcome regression. If the option "glm" is selected, the
argument \code{glm_formula} must NOT be \code{NULL}, instead containing a
model formula (as per \code{\link[stats]{glm}}) as a \code{character}. If
the option "sl" is selected, the argument \code{sl_learners} must NOT be
\code{NULL}; instead, an instantiated \pkg{sl3} \code{Lrnr_sl} object,
specifying learners and a metalearner for the Super Learner fit, must be
provided. Consult the documentation of \pkg{sl3} for details.}

\item{glm_formula}{A \code{character} giving a \code{\link[stats]{formula}}
for fitting a (generalized) linear model via \code{\link[stats]{glm}}.}

\item{sl_learners}{Object containing a set of instantiated learners from the
\pkg{sl3}, to be used in fitting an ensemble model.}
}
\value{
A \code{data.table} with two columns, containing estimates of the
 outcome mechanism at the natural value of the exposure Q(A, W) and an
 upshift of the exposure Q(A + delta, W).
}
\description{
Estimate the Outcome Mechanism
}
\details{
Compute the outcome regression for the observed data, including
 with the shift imposed by the intervention. This returns the outcome
 regression for the observed data (at A) and under the counterfactual shift
 shift (at A + delta).
}
