% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_samp}
\alias{est_samp}
\title{Estimate Probability of Censoring by Two-Phase Sampling}
\usage{
est_samp(V, C_samp, fit_type = c("sl", "glm"), sl_learners = NULL)
}
\arguments{
\item{V}{A \code{numeric} vector, \code{matrix}, \code{data.frame} or
similar object giving the observed values of the covariates known to
potentially inform the sampling mechanism.}

\item{C_samp}{A \code{numeric} vector of observed values of the indicator
for inclusion in the second-phase sample.}

\item{fit_type}{A \code{character} indicating whether to perform the fit
using GLMs or a Super Learner ensemble model. If use of Super Learner is
desired, then the argument \code{sl_learners} must be provided.}

\item{sl_learners}{An \pkg{sl3} \code{Lrnr_sl} object, a Super Learner
ensemble or learner instantiated externally using \pkg{sl3}.}
}
\value{
A \code{numeric} vector of the estimated sampling mechanism.
}
\description{
Estimate Probability of Censoring by Two-Phase Sampling
}
\details{
Compute estimates of the sampling probability for inclusion in the
 the second-phase via the two-phase sampling mechanism. These estimates are
 used for the creation of inverse probability weights.
}
