% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipper.R
\name{as.clipper}
\alias{as.clipper}
\title{As Clipper}
\usage{
as.clipper(object, slice = 1)
}
\arguments{
\item{object}{The \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} object to be coerced.}

\item{slice}{The slice to keep (a clipper is essentially a matrix).}
}
\value{
and S3 clipper
}
\description{
Coerce a \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} object to clipper. A function useful to call \code{\link{highlight_substance}} when clipping is not necessary.
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
x <- tile_sam(x)
x <- as.clipper(x)
}
