% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncondMoments.R
\name{uncondMoments}
\alias{uncondMoments}
\title{Calculate unconditional mean, variance, first p autocovariances and autocorrelations of the GSMAR process.}
\usage{
uncondMoments(gsmar)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}
}
\value{
Returns a list contaiting the unconditional mean, variance, first p autocovariances and
 autocorrelations. Note that the lag-zero autocovariance/correlation is not included in the "first p"
 but is given in the \code{uncond_variance} component separately.
}
\description{
\code{uncondMoments} calculates the unconditional mean, variance, first p autocovariances and
 autocorrelations of the GSMAR process.
}
\examples{
# GMAR model
params13 <- c(1.4, 0.88, 0.26, 2.46, 0.82, 0.74, 5.0, 0.68, 5.2, 0.72, 0.2)
gmar13 <- GSMAR(p=1, M=3, params=params13, model="GMAR")
uncondMoments(gmar13)

# StMAR model
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 100, 3.6)
stmar12t <- GSMAR(p=1, M=2, params=params12t, model="StMAR")
uncondMoments(stmar12t)

# G-StMAR model (similar to the StMAR model above)
params12gs <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 3.6)
gstmar12 <- GSMAR(p=1, M=c(1, 1), params=params12gs, model="G-StMAR")
uncondMoments(gstmar12)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for the G-StMAR model, but it's a straightforward generalization with
           theoretical properties similar to the GMAR and StMAR models.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis.
           \emph{Springer}.
 }
}
\seealso{
Other moment functions: \code{\link{condMoments}},
  \code{\link{get_regime_autocovs}},
  \code{\link{get_regime_means}},
  \code{\link{get_regime_vars}}
}
\concept{moment functions}
