% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_pc3D_dsm.R
\name{pc3D_dsm}
\alias{pc3D_dsm}
\title{Create a Digital Surface Model from a UAV generated point cloud}
\usage{
pc3D_dsm(lasDir = NULL, gisdbasePath = NULL, GRASSlocation = "tmp/",
  grassVersion = 1, searchPath = NULL, projsubFolders = c("data/",
  "output/", "run/", "las/"), gridSize = "0.25",
  grass_lidar_method = "mean", grass_lidar_pth = 90,
  splineNumber = "4", otb_gauss_radius = "0.5",
  smoothFilter = "gauss", dsm_minalt = 0, dsm_maxalt = 4000,
  dsm_area = FALSE, cutExtent = NULL,
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs",
  gisdbase_exist = FALSE, pathLastools = NULL, giLinks = NULL,
  MP = "~", verbose = FALSE)
}
\arguments{
\item{lasDir}{character. default is \code{NULL} path  to the laz/las file(s)}

\item{gisdbasePath}{character. gisdbase will be linked or created depending on \code{gisdbase_exist}}

\item{GRASSlocation}{character. location will be linked or created depending on \code{gisdbase_exist}}

\item{grassVersion}{numeric. version of GRASS as derived by findGRASS() default is 1 (=oldest/only version) please note GRASS version later than 7.4 is not working with r.inlidar}

\item{searchPath}{path to look for grass}

\item{projsubFolders}{character. subfolders that will be created/linked for R related GRASS processing}

\item{gridSize}{numeric. resolution for raster operations}

\item{grass_lidar_method}{character. statistical method to sample the Lidar data, see also \href{https://grass.osgeo.org/grass70/manuals/r.in.lidar.html}{r.in.lidar help}.}

\item{grass_lidar_pth}{numeric. grass lidar aggregation column percentile, see also \href{https://grass.osgeo.org/grass70/manuals/r.in.lidar.html}{r.in.lidar help}.}

\item{splineNumber}{numeric. default is 4 number ob spline iterations}

\item{otb_gauss_radius}{numeric. default is \code{0.5} radius of otb smoothing filter in meter}

\item{smoothFilter}{character. default is \code{gauss} alternatives are \code{spline} or for no smoothing at all \code{no}}

\item{dsm_minalt}{numeric. default is \code{0}, minimum DTM altitude accepted}

\item{dsm_maxalt}{numeric. dsm maximum altitude}

\item{dsm_area}{numeric. default \code{FALSE} generate polygon of valid DSM data}

\item{cutExtent}{numerical. clip area c(mix,miny,maxx,maxy)}

\item{proj4}{character. default is EPSG \code{32632} any valid proj4 string that is assumingly the correct one}

\item{gisdbase_exist}{logical. default is  \code{FALSE} switch if gisdbase is created or linked only}

\item{pathLastools}{character. folder containing the Windows binary files of the lastools}

\item{giLinks}{list. of GI tools cli paths as generated by a full call of link2GI}

\item{MP}{character mounting point / drive letter default is "~"}

\item{verbose}{logical. to be quiet FALSE}
}
\description{
Create a Digital Surface Model from a UAV generated point cloud. Basically returns a DSM.
It uses the 'r.in.lidar' function to calculate LiDAR derived raster grids.
It creates a \code{raster*} object.
}
\note{
For using 'PDAL'(since GRASS7.4.x) you have to install the PDAL binaries and python bindings if not bundled with GRASS. running Linux \code{sudo apt-get install libpdal-base5 libpdal-dev libpdal-plugin-python pdal}
}
\examples{
\dontrun{
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-uavRst::linkAll()
(giLinks$saga$exist & giLinks$otb$exist & giLinks$grass$exist) 
{
# proj subfolders
projRootDir<-tempdir()
setwd(projRootDir)
unlink(paste0(projRootDir,"*"), force = TRUE)

projsubFolders<-c("data/","data/ref/","output/","run/","las/")
paths<-link2GI::initProj(projRootDir = projRootDir,
                        projFolders = projsubFolders,
                        global = TRUE,
                        path_prefix = "path_")
# get some colors
pal = mapview::mapviewPalette("mapviewTopoColors")

# get the data
utils::download.file(url="https://github.com/gisma/gismaData/raw/master/uavRst/data/lidar.las",
                    destfile="lasdata.las")

# create a DSM  based on a uav point cloud
pc3DSM<-pc3D_dsm(lasDir =  "lasdata.las",
        gisdbasePath = projRootDir,
        projsubFolders = projsubFolders,
        gridSize = "0.5",
        giLinks = giLinks)
mapview::mapview(pc3DSM[[1]])
}
##+}

}
\seealso{
\href{https://grass.osgeo.org/grass70/manuals/r.in.lidar.html}{r.in.lidar help}
}
\author{
Chris Reudenbach
}
