% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_crownmetrics.R
\name{poly_metrics}
\alias{poly_metrics}
\title{calculate morphometric features of polygons.}
\usage{
poly_metrics(crownarea, funNames = c("length", "elongation",
  "eccentricityboundingbox", "solidity", "eccentricityeigen", "calliper",
  "rectangularity", "circularityharalick", "convexity"))
}
\arguments{
\item{crownarea}{sp*  spatialpolygon object}

\item{funNames}{character. names of morphometrics to be calculated
available are ("length","elongation","eccentricityboundingbox","solidity","eccentricityeigen",
"calliper","rectangularity","circularityharalick","convexity")}
}
\description{
calculate morphometric features of polygons. Calculate some crown related metrics, returns the metrics as a spatialpointdataframe/spatialpolygondataframe
}
\examples{

\dontrun{
# required packages
require(uavRst)
require(link2GI)
require(mapview)

# project folder
projRootDir<-tempdir()

# create subfolders please mind that the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = projRootDir,
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")
# overide trailing backslash issue
 path_run<-ifelse(Sys.info()["sysname"]=="Windows", sub("/$", "",path_run),path_run)
 setwd(path_run)

# get the rgb image, chm and training data
utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip",
                      paste0(path_run,"tutorial_data.zip"))
unzip(zipfile = paste0(path_run,"tutorial_data.zip"), exdir = path_run)
crown<-raster::shapefile(paste0(path_run,"rgb_3-3_train2.shp"))
## calculate polygon morpho metrics
polymetric <- poly_metrics(crown)

# visualize it
mapview::mapview(polymetric)
##+}
}
\seealso{
\href{https://CRAN.R-project.org/package=Momocs}{Momocs}
\href{https://www.researchgate.net/profile/Paul_Rosin/publication/228382248_Computing_global_shape_measures/links/0fcfd510802e598c31000000.pdf?origin=publication_detail}{Paul Rosin}
}
