% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_bluedjinn.R
\name{split2SAGA}
\alias{split2SAGA}
\title{Split multiband image to single band SAGA files}
\usage{
split2SAGA(
  fn = NULL,
  bandName = NULL,
  startBand = 1,
  endBand = 3,
  refFn = NULL,
  gdalLinks = NULL,
  returnRaster = FALSE
)
}
\arguments{
\item{fn}{character. filename}

\item{startBand}{numerial. last band to export}

\item{refFn}{character. reference image for resampling}

\item{gdalLinks}{list of gdal installations}

\item{returnRaster}{logical. return as raster}

\item{bandname}{character. list of bandnames c("red","green","blue")}
}
\value{
if returnRaster the splitted SAGA raster is returned as an raster* object
}
\description{
Split multiband image to single band SAGA files. If a reference file is given, it performs a resample if necessary to avoid the numerical noise problem of SAGA extent.
}
\keyword{internal}
