% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{load_uba_data_from_dir}
\alias{load_uba_data_from_dir}
\title{Load UBA Data from Directory}
\usage{
load_uba_data_from_dir(data_dir)
}
\arguments{
\item{data_dir}{Character. Path to the directory containing \code{.csv} files.}
}
\value{
A \code{data.table} containing the loaded data in long format. Returns an error if no valid
files are found or the resulting dataset is empty.
}
\description{
This function loads data from CSV files in the specified directory. It supports two formats:
}
\details{
\enumerate{
\item "inv": Files must contain the following columns:
\itemize{
\item \code{Station}, \code{Komponente}, \code{Datum}, \code{Uhrzeit}, \code{Wert}.
}
\item "24Spalten": Files must contain:
\itemize{
\item \code{Station}, \code{Komponente}, \code{Datum}, and columns \code{Wert01}, ..., \code{Wert24}.
}
}

File names should include "inv" or "24Spalten" to indicate their format. The function scans
recursively for \code{.csv} files in subdirectories and combines the data into a single \code{data.table}
in long format.
Files that are not in the exected format will be ignored.
}
