% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{timecourse_stats}
\alias{timecourse_stats}
\title{Calculate Timecourse Statistics for a Matrix of Responses}
\usage{
timecourse_stats(d, ci)
}
\arguments{
\item{d}{matrix of responses (each row an individual and each column a time point)}

\item{ci}{confidence interval in percent (eg, 95)}
}
\value{
List with the following elements:

\itemize{
  \item \code{stats$ub_ci}  vector of confidence interval upper bound 
  \item \code{stats$lb_ci}  vector of confidence interval lower bound 
  \item \code{stats$mean}   vector of mean values
  \item \code{stats$median} vector of median values
  }
}
\description{
Given a matrix (d) of time courses (each row is an individual and each column is
 a time point) and a confidence interval (ci) this will calculate the mean,
 median, confidence intervals and a vector of values for creating patches.
}
\keyword{internal}
