% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrInfluential.R
\name{regrInfluential}
\alias{regrInfluential}
\alias{print.regrInfluential}
\title{Detecting influential cases in regression analyses}
\usage{
regrInfluential(formula, data, createPlot = TRUE)

\method{print}{regrInfluential}(x, headingLevel = 3, ...)
}
\arguments{
\item{formula}{The formule of the regression analysis.}

\item{data}{The data to use for the analysis.}

\item{createPlot}{Whether to create the scattermatrix (requires the \code{GGally}
package to be installed).}

\item{x}{Object to print.}

\item{headingLevel}{The number of hash symbols to prepend to the heading.}

\item{...}{Additional arguments are passed on to the \code{regr} print function.}
}
\value{
A \code{regrInfluential} object, which, if printed, shows the
influential cases, the regression analyses repeated without those cases, and
the scatter matrix.
}
\description{
This function combines a number of criteria for determining whether a
datapoint is an influential case in a regression analysis. It then sum the
criteria to compute an index of influentiality. A list of cases with an
index of influentiality of 1 or more is then displayed, after which the
regression analysis is repeated without those influantial cases. A
scattermatrix is also displayed, showing the density curves of each
variable, and in the scattermatrix, points that are colored depending on how
influential each case is.
}
\examples{

regrInfluential(mpg ~ hp, mtcars);

}
\author{
Gjalt-Jorn Peters & Marwin Snippe

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
