% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/street-crime-outcome.R
\name{ukc_street_crime_outcome}
\alias{ukc_street_crime_outcome}
\title{Street level crime outcomes}
\usage{
ukc_street_crime_outcome(lat, lng, location, date = NULL)
}
\arguments{
\item{lat}{Latitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{lng}{Longitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{location}{If specified, \code{lat} and \code{lng} are ignored. Location IDs are
available through other methods including \code{\link[=ukc_street_crime]{ukc_street_crime()}}.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned.}
}
\value{
A tibble with details of street crime outcomes.
}
\description{
Returns details on crimes at a given location, if given the id of a specific
location. If given latitude and longitude, finds the nearest pre-defined
location and returns the crimes which occurred there.
}
\details{
If specified, \code{lat} and \code{lng} must be the same length. \code{location}
or both \code{lat} and \code{lng} must be specified.
}
\examples{
\dontrun{
street_crime_outcome1 <- ukc_street_crime_outcome(location = 883498)

street_crime_outcome2 <- ukc_street_crime_outcome(lat = 52, lng = 0)
}

}
